library(tidyverse)
library(dplyr)
setwd('/home/wangyiqi/wyq/otherRNA/zhangruolin/miRNA_20220208/database_intersection/intersect/genes/genes0222')
library(clusterProfiler)
library(DOSE)
library(org.Hs.eg.db)
sig.gene<-read.csv("mRNA.csv")
gene=sig.gene[,1]
gene.df<-bitr(gene, fromType = "SYMBOL",  toType = c("ENTREZID"),OrgDb = org.Hs.eg.db)
ego <- enrichGO(gene  = gene.df$ENTREZID,
                OrgDb         = org.Hs.eg.db,
                keyType       = 'ENTREZID',##指定gene id的类型
                ont           = "BP",##GO分类
                pAdjustMethod = "BH",
                pvalueCutoff  = 0.99,##设置阈值
                qvalueCutoff  = 0.99,
                readable=TRUE)
write.csv(ego,file="csv/gsea_GO_BP1.csv")
ego_kk2=read.csv("csv/gsea_GO_BP1.csv",header=T,row.names = 1)
ego_kk3=filter(ego_kk2,pvalue<0.05)
num=which(ego$ID %in% rownames(ego_kk3))
ego@result<-ego[num,]
write.csv(ego,file="csv/ego_bp.csv")
pdf("ego_bp.pdf",height=20,width=8)
dotplot(ego,showCategory = 50, color="pvalue",title="The GO_BP enrichment analysis of up DEGs")+
  scale_size(range=c(2, 12))+
  scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
dev.off()


ego <- enrichGO(gene  = gene.df$ENTREZID,
                OrgDb         = org.Hs.eg.db,
                keyType       = 'ENTREZID',##指定gene id的类型
                ont           = "CC",##GO分类
                pAdjustMethod = "BH",
                pvalueCutoff  = 0.99,##设置阈值
                qvalueCutoff  = 0.99,
                readable=TRUE)
write.csv(ego,file="csv/gsea_GO_CC1.csv")
ego_kk2=read.csv("csv/gsea_GO_CC1.csv",header=T,row.names = 1)
ego_kk3=filter(ego_kk2,pvalue<0.05)
num=which(ego$ID %in% rownames(ego_kk3))
ego@result<-ego[num,]
write.csv(ego,file="csv/ego_cc.csv")
pdf("ego_cc.pdf",height=10,width=8)
dotplot(ego,showCategory = 40, color="pvalue",title="The GO_CC enrichment analysis of up DEGs")+
  scale_size(range=c(2, 12))+
  scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
dev.off()

ego <- enrichGO(gene  = gene.df$ENTREZID,
                OrgDb         = org.Hs.eg.db,
                keyType       = 'ENTREZID',##指定gene id的类型
                ont           = "MF",##GO分类
                pAdjustMethod = "BH",
                pvalueCutoff  = 0.99,##设置阈值
                qvalueCutoff  = 0.99,
                readable=TRUE)
write.csv(ego,file="csv/gsea_GO_MF1.csv")
ego_kk2=read.csv("csv/gsea_GO_MF1.csv",header=T,row.names = 1)
ego_kk3=filter(ego_kk2,pvalue<0.05)
num=which(ego$ID %in% rownames(ego_kk3))
ego@result<-ego[num,]
write.csv(ego,file="csv/ego_mf.csv")
pdf("ego_MF.pdf",height=20,width=8)
dotplot(ego,showCategory = 40,color="pvalue", title="The GO_MF enrichment analysis of up DEGs")+
  scale_size(range=c(2, 12))+
  scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
dev.off()


ekegg <- enrichKEGG(
    gene  = gene.df$ENTREZID,
    keyType  = 'kegg',
    organism = 'human',
    pvalueCutoff = 0.99,
    pAdjustMethod     = "BH",
    qvalueCutoff  = 0.99
  )
  egokegg=DOSE::setReadable(ekegg, OrgDb='org.Hs.eg.db',keyType='ENTREZID')
  write.csv(egokegg,file="csv/gsea_GO_KEGG1.csv")
  ego_kk2=read.csv("csv/gsea_GO_KEGG1.csv",header=T,row.names = 1)
  ego_kk3=filter(ego_kk2,pvalue<0.05)
  num=which(ekegg$ID %in% rownames(ego_kk3))
  ekegg@result<-ekegg[num,]
  write.csv(ekegg,file="csv/ekegg.csv")
  pdf("ego_KEGG.pdf",height=10,width=8)
  dotplot(ekegg,showCategory = 40,color="pvalue", title="The KEGG enrichment analysis of up DEGs")+
    scale_size(range=c(2, 12))+
    scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
  dev.off()
  
  library(tidyverse)
  library(dplyr)
  setwd('/home/wangyiqi/wyq/otherRNA/zhangruolin/miRNA_20220208/database_intersection/intersect/genes/genes0223')
  library(clusterProfiler)
  library(DOSE)
  library(org.Hs.eg.db)
  sig.gene<-read.csv("mRNA.csv")
  gene=sig.gene[,1]
  gene.df<-bitr(gene, fromType = "SYMBOL",  toType = c("ENTREZID"),OrgDb = org.Hs.eg.db)
  ego <- enrichGO(gene  = gene.df$ENTREZID,
                  OrgDb         = org.Hs.eg.db,
                  keyType       = 'ENTREZID',##指定gene id的类型
                  ont           = "BP",##GO分类
                  pAdjustMethod = "BH",
                  pvalueCutoff  = 0.99,##设置阈值
                  qvalueCutoff  = 0.99,
                  readable=TRUE)
  write.csv(ego,file="csv/gsea_GO_BP1.csv")
  ego_kk2=read.csv("csv/gsea_GO_BP1.csv",header=T,row.names = 1)
  ego_kk3=filter(ego_kk2,pvalue<0.05)
  #num=which(ego$ID %in% rownames(ego_kk3))
  num=which(ego$ID %in% c("GO:1901215","GO:0043524","GO:0050808","GO:0000302","GO:0072593","GO:1900408","GO:1903202","GO:0014823","GO:0097237","GO:1903204"))
  ego@result<-ego[num,]
  write.csv(ego,file="csv/ego_bp.csv")
  pdf("ego_bp.pdf",height=6,width=8)
  dotplot(ego,showCategory = 50, color="pvalue",title="The GO_BP enrichment analysis of target genes")+
    scale_size(range=c(2, 12))+
    scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
  dev.off()
  
  
  ego <- enrichGO(gene  = gene.df$ENTREZID,
                  OrgDb         = org.Hs.eg.db,
                  keyType       = 'ENTREZID',##指定gene id的类型
                  ont           = "CC",##GO分类
                  pAdjustMethod = "BH",
                  pvalueCutoff  = 0.99,##设置阈值
                  qvalueCutoff  = 0.99,
                  readable=TRUE)
  write.csv(ego,file="csv/gsea_GO_CC1.csv")
  ego_kk2=read.csv("csv/gsea_GO_CC1.csv",header=T,row.names = 1)
  ego_kk3=filter(ego_kk2,pvalue<0.05)
  #num=which(ego$ID %in% rownames(ego_kk3))
  num=which(ego$ID %in% c("GO:0150034","GO:0014069","GO:0032279","GO:0098984","GO:0043194","GO:0032839","GO:0005782","GO:0045334","GO:0005778"))
  ego@result<-ego[num,]
  write.csv(ego,file="csv/ego_cc.csv")
  pdf("ego_cc.pdf",height=6,width=8)
  dotplot(ego,showCategory = 40, color="pvalue",title="The GO_CC enrichment analysis of target genes")+
    scale_size(range=c(2, 12))+
    scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
  dev.off()
  
  ego <- enrichGO(gene  = gene.df$ENTREZID,
                  OrgDb         = org.Hs.eg.db,
                  keyType       = 'ENTREZID',##指定gene id的类型
                  ont           = "MF",##GO分类
                  pAdjustMethod = "BH",
                  pvalueCutoff  = 0.99,##设置阈值
                  qvalueCutoff  = 0.99,
                  readable=TRUE)
  write.csv(ego,file="csv/gsea_GO_MF1.csv")
  ego_kk2=read.csv("csv/gsea_GO_MF1.csv",header=T,row.names = 1)
  ego_kk3=filter(ego_kk2,pvalue<0.05)
  #num=which(ego$ID %in% rownames(ego_kk3))
  num=which(ego$ID %in% c("GO:0016209","GO:0005126","GO:0008083","GO:0005125","GO:0005165","GO:0042813","GO:0048020","GO:0032813","GO:0008009","GO:0004601"))
  ego@result<-ego[num,]
  write.csv(ego,file="csv/ego_mf.csv")
  pdf("ego_MF.pdf",height=6,width=8)
  dotplot(ego,showCategory = 40,color="pvalue", title="The GO_MF enrichment analysis of target genes")+
    scale_size(range=c(2, 12))+
    scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
  dev.off()
  
  
  ekegg <- enrichKEGG(
    gene  = gene.df$ENTREZID,
    keyType  = 'kegg',
    organism = 'human',
    pvalueCutoff = 0.99,
    pAdjustMethod     = "BH",
    qvalueCutoff  = 0.99
  )
  egokegg=DOSE::setReadable(ekegg, OrgDb='org.Hs.eg.db',keyType='ENTREZID')
  write.csv(egokegg,file="csv/gsea_GO_KEGG1.csv")
  ego_kk2=read.csv("csv/gsea_GO_KEGG1.csv",header=T,row.names = 1)
  ego_kk3=filter(ego_kk2,pvalue<0.05)
  #num=which(ekegg$ID %in% rownames(ego_kk3))
  num=which(ekegg$ID %in% c("hsa04068","hsa05022","hsa04146","hsa04061","hsa04150","hsa04630"))
  ekegg@result<-ekegg[num,]
  write.csv(ekegg,file="csv/ekegg.csv")
  pdf("ego_KEGG.pdf",height=6,width=8)
  dotplot(ekegg,showCategory = 40,color="pvalue", title="The KEGG enrichment analysis of target genes")+
    scale_size(range=c(2, 12))+
    scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
  dev.off()
  
  
  
  library(tidyverse)
  library(dplyr)
  setwd('/home/wangyiqi/wyq/otherRNA/zhangruolin/miRNA_20220208/database_intersection/intersect/genes/genes0304')
  library(clusterProfiler)
  library(DOSE)
  library(org.Hs.eg.db)
  sig.gene<-read.csv("mRNA.csv")
  gene=sig.gene[,1]
  gene.df<-bitr(gene, fromType = "SYMBOL",  toType = c("ENTREZID"),OrgDb = org.Hs.eg.db)
  ego <- enrichGO(gene  = gene.df$ENTREZID,
                  OrgDb         = org.Hs.eg.db,
                  keyType       = 'ENTREZID',##指定gene id的类型
                  ont           = "BP",##GO分类
                  pAdjustMethod = "BH",
                  pvalueCutoff  = 0.99,##设置阈值
                  qvalueCutoff  = 0.99,
                  readable=TRUE)
  write.csv(ego,file="csv/gsea_GO_BP1.csv")
  ego_kk2=read.csv("csv/gsea_GO_BP1.csv",header=T,row.names = 1)
  ego_kk3=filter(ego_kk2,pvalue<0.05)
  #num=which(ego$ID %in% rownames(ego_kk3))
  num=which(ego$ID %in% c("GO:1901214","GO:0010721","GO:0001819","GO:0051092","GO:0050768","GO:0031098","GO:0097191","GO:0070498","GO:1903409"))
  ego@result<-ego[num,]
  write.csv(ego,file="csv/ego_bp_selected.csv")
  pdf("ego_bp_selected.pdf",height=7,width=8)
  dotplot(ego,showCategory = 30, color="pvalue",title="The GO_BP enrichment analysis of target genes")+
    scale_size(range=c(2, 12))+
    scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
  dev.off()
  
  
  ego <- enrichGO(gene  = gene.df$ENTREZID,
                  OrgDb         = org.Hs.eg.db,
                  keyType       = 'ENTREZID',##指定gene id的类型
                  ont           = "CC",##GO分类
                  pAdjustMethod = "BH",
                  pvalueCutoff  = 0.99,##设置阈值
                  qvalueCutoff  = 0.99,
                  readable=TRUE)
  write.csv(ego,file="csv/gsea_GO_CC1.csv")
  ego_kk2=read.csv("csv/gsea_GO_CC1.csv",header=T,row.names = 1)
  ego_kk3=filter(ego_kk2,pvalue<0.05)
  #num=which(ego$ID %in% rownames(ego_kk3))
  num=which(ego$ID %in% c("GO:0043197","GO:0044309","GO:0005741","GO:0045211","GO:0014069","GO:0098978","GO:0098984","GO:0030877","GO:0098878"))
  ego@result<-ego[num,]
  write.csv(ego,file="csv/ego_cc_selected.csv")
  pdf("ego_cc_selected.pdf",height=7,width=8)
  dotplot(ego,showCategory = 30, color="pvalue",title="The GO_CC enrichment analysis of target genes")+
    scale_size(range=c(2, 12))+
    scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
  dev.off()
  
  ego <- enrichGO(gene  = gene.df$ENTREZID,
                  OrgDb         = org.Hs.eg.db,
                  keyType       = 'ENTREZID',##指定gene id的类型
                  ont           = "MF",##GO分类
                  pAdjustMethod = "BH",
                  pvalueCutoff  = 0.99,##设置阈值
                  qvalueCutoff  = 0.99,
                  readable=TRUE)
  write.csv(ego,file="csv/gsea_GO_MF1.csv")
  ego_kk2=read.csv("csv/gsea_GO_MF1.csv",header=T,row.names = 1)
  ego_kk3=filter(ego_kk2,pvalue<0.05)
  #num=which(ego$ID %in% rownames(ego_kk3))
  num=which(ego$ID %in% c("GO:0005126","GO:0005164","GO:0031624","GO:0048020","GO:0032813","GO:0042379","GO:0070491","GO:0008013","GO:0070851"))
  ego@result<-ego[num,]
  write.csv(ego,file="csv/ego_mf_selected.csv")
  pdf("ego_MF_selected.pdf",height=7,width=8)
  dotplot(ego,showCategory = 30,color="pvalue", title="The GO_MF enrichment analysis of target genes")+
    scale_size(range=c(2, 12))+
    scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
  dev.off()
  
  
  ekegg <- enrichKEGG(
    gene  = gene.df$ENTREZID,
    keyType  = 'kegg',
    organism = 'human',
    pvalueCutoff = 0.99,
    pAdjustMethod     = "BH",
    qvalueCutoff  = 0.99
  )
  egokegg=DOSE::setReadable(ekegg, OrgDb='org.Hs.eg.db',keyType='ENTREZID')
  write.csv(egokegg,file="csv/gsea_GO_KEGG1.csv")
  ego_kk2=read.csv("csv/gsea_GO_KEGG1.csv",header=T,row.names = 1)
  ego_kk3=filter(ego_kk2,pvalue<0.05)
  #  num=which(ekegg$ID %in% rownames(ego_kk3))
  num=which(egokegg$ID %in% c("hsa05130","hsa04657","hsa04064","hsa04620","hsa04062","hsa04722","hsa04380","hsa04068","hsa05321"))
  egokegg@result<-egokegg[num,]
  write.csv(egokegg,file="csv/ekegg_selected.csv")
  pdf("ego_KEGG_selected.pdf",height=7,width=8)
  dotplot(egokegg,showCategory = 30,color="pvalue", title="The KEGG enrichment analysis of target genes")+
    scale_size(range=c(2, 12))+
    scale_y_discrete(labels=function(ego) str_wrap(ego,width = 25))
  dev.off()
  
  
  
  



